
% It computes the classification of sub-tracks of lenght T by using the
% statistical method proposed by Briane, Vimond, Kevrann in "Adaptative
% Statistical Test to Detect Non-Brownian Diffusion from Particle
% Trajectories"
%
% INPUT 
% - TRACKS: it contains all the tracks
% - INT   : it contains (Sheet 1)  the intensity of the spots 
% - SURF  : it contains  the  area of the spots
% - T     : lenght of the sub-tracks to analyze
% - t_msd : parameter to calculate the linear regression of msd-curve on
%           [1, t_msd]
%
% OUTPUT
% - It computes the percentage of each mouvement class and the number of
%   analyzed class (see motion_classification).
% - PERCENTAGE is a string containing the percetnage of all class of
%   mouvement.
% - It performs all the outputs detailed in classification.m


clear all
close all
addpath('./DATA/');



% Initial parameters
 T=5; % lenght tracks is equal to T+1
 t_msd=4;    % lenght msd :t_msd < T !
 pourc=.10;  % pourcentage of virtual detection in deleted tracks
 tau = .03;     % echelle de temps
 
 tau_space = .1 ; % echelle d'espace
 %
 NAMES={'Classeur_track S1_example'};
 %,'WTPSCRANTES2','L196K2','AB ALONE', 'L196C2',  'prot25-3', 'prot34-3', 'WT Myriocin', 'WT-CCL4-2', 'WT-MVC', 'WT-PTX-2','WT-TAK799-1'};

 count=10;
 problem=0;
 
for k=1:numel(NAMES)
    namecase=NAMES{k};
    
    file = [namecase, '.xlsx'];
    [A,Sheets]=xlsfinfo(file);
    nbsheets = numel(Sheets);        
     
  for l=1:1:nbsheets,
            
% Files
   name = [namecase, '-cell-', num2str(l)];
   M =xlsread(file,l);
   disp(name)
  
  %% Delete virtual 

  [M, N, nbdeleted, Detect_immimm] = delete_virtual(M, pourc,T);
  
  %% Information 
  % T | t_msd | pourc | # original tracks | # deleted tracks | # Sheets
  
  INFO = [T, t_msd, pourc, N, nbdeleted, nbsheets];  
  save_name=['./RESULTS/' name '-INFO'] ;
  %# create a table
  %# write to file
  csvwrite(save_name,INFO);
  
  %% Splitting tracks 
  disp('splitting tracks')
  [TRACKS,TRACKSwithallimmo,allimmobiles, N_origtracks, Orig_immo, LENGTHS, Ext_global, Extdivlength, EXT] = define_tracks(M, T, tau_space, Detect_immimm);
  
  %% Classification   non-immobile tracks
  disp('classification')
  [pourc, Resume]  = classification(TRACKS,T, t_msd, tau, tau_space, name);
  
    %% Classification   with all-immobile tracks
  disp('classification with all immobile tracks')
  [pourcwithallimmo, Resumewithallimmo]  = classification(TRACKSwithallimmo,T, t_msd, tau, tau_space, [name,'-withallimmo']);

  %% Variability of mouvement

  VAR = study_variability(Resume, EXT);
  
  %%  Histograms of number of motion variations and number of subtracks

   count = study_variations(VAR,name,count, allimmobiles,N_origtracks, Ext_global);   
 
close all
  end
end


   
